using System;

namespace Server.Items
{
	public class GuildCoin : Item
	{
		[Constructable]
		public GuildCoin() : this( 1 )
		{
		}

		[Constructable]
		public GuildCoin( int amount ) : base( 3824 )
		{
			Weight = 0.01;
			Stackable = true;
			Amount = amount;
			Name = "guild coin";
			Hue = 1366;
		}
		
		public override int GetDropSound()
		{
			if ( Amount <= 1 )
				return 0x2E4;
			else if ( Amount <= 5 )
				return 0x2E5;
			else
				return 0x2E6;
		}

		public GuildCoin( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}